<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_471.xsd"
                xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
    <xsl:template match="ns1:SENT_471">
        <!-- TODO: Auto-generated template -->
        <html>
            <head>
              <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});
languative.modifyDictionary("pl", {
sent471: "SENT471 - POTWIERDZENIE REJESTRACJI URZĄDZEŃ GPS PRZEWOŹNIKA POWIĄZANYCH Z USŁUGĄ ZSL",
selectLanguage: "Wybierz język:",
english: "English",
polish: "Polski",
sentZSLServiceNumber: "NUMER USŁUGI ZSL:",
sentZSLCarrierPassword: "Hasło autoryzacyjne przewoźnika do usługi ZSL",
sentRegisteredInfoGPS: "Informacje dotyczące niniejszego zgłoszenia",
sentSourceDocumentID: "Numer własny zgłoszenia:",
sentChecksumOfSourceDoc: "Suma kontrolna:",
sentZSLCarrierStatus: "Status usługi ZSL przewoźnika:",
sentZSLServiceStatusValue1: "zarejestrowany",
sentZSLServiceStatusValue2: "zmodyfikowany",
sentZSLServiceStatusValue3: "anulowany",
sentDateOfRegistration: "Data rejestracji:",
sentCreatedUser: "Użytkownik rejestrujący zgłoszenie:",
sentModificationUserDate: "Data modyfikacji",
sentModifierUser: "Użytkownik modyfikujący zgłoszenie:",
sentZSLCarrier: "Informacje o przewoźniku rejestrującym urządzenia GPS",
sentBasicInfo: "Informacje podstawowe",
sentIdSisc: "Identyfikator idSISC:",
sentTraderName: "Pełna nazwa:",
sentTraderIdentityType: "Rodzaj identyfikatora:",
sentTraderIdentityNumber: "Numer identyfikatora:",
sentAdress: "Informacje adresowe",
sentRegisteredDevices: "Wykaz urządzeń GPS przewoźnika powiązanych z usługą ZSL",
sentGPSDeviceID2: "Identyfikator techniczny urządzenia GPS",
sentGeoLocatorNr: "Numer urządzenia GPS",
sentGPSDeviceStatus: "Status urządzenia GPS",
sentAdditionalInfo: "Informacje dodatkowe",
sentCreationDate: "Data rejestracji",
sentCreator: "Użytkownik rejestrujący",
sentModificationDate: "Data modyfikacji",
sentModifier: "Użytkownik modyfikujący",
sentNoRegisteredDevices: "Nie zarejestrowano żadnych urządzeń",
sentAdministratorServicesCarrierZSL: "Informacje kontaktowe do administratora przewoźnika rejestrującego urządzenia GPS",
sentPhoneNumber: "Numer telefonu:",
sentEmail1: "Adres e-mail:",
sentComplianceComments: "Uwagi:"
});

languative.modifyDictionary("en", {
sent471: "SENT471 - CONFIRMATION OF REGISTRATION OF THE CARRIER'S GPS DEVICES RELATED TO ZSL SERVICE",
selectLanguage: "Select language:",
english: "English",
polish: "Polski",
sentZSLServiceNumber: "NUMBER OF THE ZSL SERVICE:",
sentZSLCarrierPassword: "Authorisation password to ZSL service assigned to the carrier",
sentRegisteredInfoGPS: "Information about the notification",
sentSourceDocumentID: "Own number of the document:",
sentChecksumOfSourceDoc: "Checksum:",
sentZSLCarrierStatus: "Status of the ZSL carrier's service:",
sentZSLServiceStatusValue1: "registered",
sentZSLServiceStatusValue2: "modified",
sentZSLServiceStatusValue3: "cancelled",
sentDateOfRegistration: "Registration date:",
sentCreatedUser: "Registered by:",
sentModificationUserDate: "Modification date",
sentModifierUser: "Modifying user:",
sentZSLCarrier: "Information about the carrier registering GPS devices",
sentBasicInfo: "Basic information",
sentIdSisc: "idSISC identification number:",
sentTraderName: "Full name:",
sentTraderIdentityType: "Identification type:",
sentTraderIdentityNumber: "Identification number:",
sentAdress: "Address information",
sentRegisteredDevices: "List of GPS devices related to the ZSL service",
sentGPSDeviceID2: "Technical identifier of the GPS device",
sentGeoLocatorNr: "Number of the GPS device",
sentGPSDeviceStatus: "Status of the GPS device",
sentAdditionalInfo: "Additional information",
sentCreationDate: "Creation date",
sentCreator: "User registering",
sentModificationDate: "Modification date",
sentModifier: "User modifying the notification",
sentNoRegisteredDevices: "No devices have been registered",
sentAdministratorServicesCarrierZSL: "Contact details to the administrator of the carrier that registers a GPS device",
sentPhoneNumber: "Phone number:",
sentEmail1: "E-mail address:",
sentComplianceComments: "Comments:"
});


function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}

//]]>

                </script>
              <style>
                * {
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
                }

                @media print {
                body {-webkit-print-color-adjust: exact;}
                }

                body {
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                margin: 0 auto;
                padding: 0 auto;
                }

                .sent-xslt {
                border-collapse: initial;
                }

                .sent-xslt h1 {
                padding: 6px 4px 4px 10px;
                color:#000000;
                margin-top: 0;
                background-color:#c5c2c2;
                font-weight: normal;
                font-size: 12px;
                margin-bottom: 0;
                border-bottom: 1px solid #c8c9ca;
                }

                .sent-xslt .s1 {
                max-width: 1220px;
                border: 1px solid #c8c9ca;
                }

                .sent-xslt .t1 {
                position: relative;
                display: table;
                width: 100%;
                }

                .sent-xslt .t2 {
                padding: 15px 5px 3px 5px;
                border: 1px solid;
                margin: 0 10px 20px 10px;
                }

                .sent-xslt .t3 {
                padding: 15px 5px 3px 5px;
                border: 1px solid red;
                margin: 0 10px 20px 10px;
                }

                .sent-xslt .grupName {
                font-size: 12px;
                margin: 0 !important;
                font-weight: bold;
                display:block;
                color: #000000;
                background-color:#dbddde;
                padding:5px 5px 5px 10px;
                border-top: 1px solid #dbddde;
                }

                .sent-xslt .grupNameRed {
                font-size: 14px;
                margin: -15px -5px 0 -5px;
                font-weight: bold;
                display:block;
                color: #000000;
                background-color:red;
                padding:5px 5px 5px 10px;
                border: 1px solid red;
                }

                .sent-xslt .element-1 {
                font-size: 12px;
                font-weight: normal;
                }

                .sent-xslt .element-2 {
                font-size: 14px;
                font-weight: normal;
                color: #008540;
                }

                .sent-xslt .green {
                background-color: #DAFFCC;
                height: 35px;
                padding-top: 4px;
                }

                .sent-xslt .green-key {
                background-color: #DAFFCC;
                padding: 7px 0px !important;
                }

                .sent-xslt .element-3 {
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                font-size: 12px;
                font-weight: normal;
                border-spacing: 10 10;
                white-space: pre-wrap; /* Since CSS 2.1 */
                white-space: -moz-pre-wrap; /* Mozilla, since 1999 */
                white-space: -pre-wrap; /* Opera 4-6 */
                white-space: -o-pre-wrap; /* Opera 7 */
                word-wrap: break-word; /* Internet Explorer 5.5+ */
                word-break: normal;
                }
                
                .sent-xslt .grupInfo p {
                margin: 1px 0 1px 10px;
                font-weight: bold;
                font-size: 12px;
                }

                .sent-xslt .grupInfo {
                border-top: 1px solid #dbddde;
                }

                .sent-xslt .grupInfoSent {
                min-height: 40px;
                }

                .sent-xslt .grupInfoSent p {
                margin: -2px 0 1px 10px;
                font-size: 16px;
                font-weight: bold;
                }

                .sent-xslt .oilstatus {
                margin: 0 5px 0 -5px;
                margin: 2px 0 1px 10px;
                font-size: 14px;
                padding-bottom: 12px;
                color: red;
                }

                .sent-xslt .info {
                width: 100%;
                float: left;
                display: table-cell;
                padding: 4px 0px;
                }

                .sent-xslt .info1 {
                width: 50%;
                float: left;
                display: table-cell;
                padding: 4px 0px;
                }

                .sent-xslt .info3 {
                width: 33%;
                float: left;
                display: table-cell;
                }

                .sent-xslt .lang ul {
                margin: 0 auto;
                padding: 0;
                }

                .sent-xslt .lang ul li {
                display: inline;
                margin-left: 10px;
                }

                .sent-xslt .table {
                display: table;
                width: 99%;
                margin: 4px 0 15px 7px;
                border-spacing: 0 0;
                border-top: 1px solid #999999;
                border-left: 1px solid #999999;
                }

                .sent-xslt .table-header {
                font-size: 10px;
                font-weight: bold;
                padding: 5px;
                background-color: #ececec;
                border-bottom: 1px solid #999999;
                border-right: 1px solid #999999;
                }

                .sent-xslt .table-element {
                font-size: 12px;
                font-weight: normal;
                padding: 2px 5px;
                border-bottom: 1px solid #999999;
                border-right: 1px solid #999999;
                }

                .sent-xslt .table-element2 {
                font-size: 12px;
                font-weight: normal;
                padding: 0;
                }

                .sent-xslt .table-element3 {
                font-size: 12px;
                font-weight: bold;
                border: 1px #999999;
                border-top-style: solid;
                margin: 0;
                }

                .sent-xslt .table-element p {
                margin-left: 0;
                }

                .sent-xslt .table-element2 p {
                margin-left: 0;
                }

                .sent-xslt .table-element3 p {
                margin-left: 0;
                padding: 0px 5px;
                }

              </style>
            </head>
          <body>
            <div class="sent-xslt">
              <section class="sent-xslt s1">
                <div class="sent-xslt lang">
                  <ul>
                    <li>
                      <span class="sent-xslt element-1" data-phrase-id="selectLanguage"></span>
                    </li>
                    <li>
                      <span class="sent-xslt element-1">
                        <a href="#" onclick="languative.changeLanguage('en');">
                          <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                        </a>
                      </span>
                    </li>
                    <li>
                      <span class="sent-xslt element-1">
                        <a href="#" onclick="languative.changeLanguage('pl');">
                          <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                        </a>
                      </span>
                    </li>
                  </ul>
                </div>
                <h1 data-phrase-id="sent471"></h1>
                <div class="sent-xslt t1">
                  <div class="sent-xslt grupInfoSent">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1 sent" data-phrase-id="sentZSLServiceNumber"></span>
                        <br/>
                        <xsl:value-of select="ns1:ZSLServiceNumber"/>
                      </p>
                    </div>
                    <xsl:if test="ns1:ZSLCarrierPassword != ''">
                    <div class="sent-xslt info1 green-key">
                      <p>
                        <span class="sent-xslt element-1 sent" data-phrase-id="sentZSLCarrierPassword"></span>
                        <br/>
                        <xsl:value-of select="ns1:ZSLCarrierPassword"/>
                      </p>
                    </div>
                    </xsl:if>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentRegisteredInfoGPS"></p>
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <xsl:if test="ns1:RegisteredInfo/ns1:SourceDocumentId !=''">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentSourceDocumentID"></span>
                          <xsl:value-of select="ns1:RegisteredInfo/ns1:SourceDocumentId"/>
                        </p>
                      </xsl:if>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentChecksumOfSourceDoc"></span>
                        <xsl:value-of select="ns1:RegisteredInfo/ns1:ChecksumOfSourceDocument"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentZSLCarrierStatus"></span>
                        <xsl:choose>
                          <xsl:when test="ns1:RegisteredInfo/ns1:ZSLCarrierStatus = '0'">
                            <span data-phrase-id="sentZSLServiceStatusValue1"></span>
                          </xsl:when>
                          <xsl:when test="ns1:RegisteredInfo/ns1:ZSLCarrierStatus = '2'">
                            <span data-phrase-id="sentZSLServiceStatusValue2"></span>
                          </xsl:when>
                          <xsl:when test="ns1:RegisteredInfo/ns1:ZSLCarrierStatus = '4'">
                            <span data-phrase-id="sentZSLServiceStatusValue3"></span>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="ns1:RegisteredInfo/ns1:ZSLCarrierStatus"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </p>
                    </div>
                    <div class="sent-xslt info1">
                      <xsl:variable name="creDate" select="substring-before(ns1:RegisteredInfo/ns1:CreationDate, 'T')"/>
                      <xsl:variable name="creTime" select="substring(ns1:RegisteredInfo/ns1:CreationDate, 12,8)"/>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentDateOfRegistration"></span>
                        <xsl:value-of select="$creDate"/> godz.<xsl:value-of select="$creTime"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentCreatedUser"></span>
                        <xsl:value-of select="ns1:RegisteredInfo/ns1:Creator"/>
                      </p>
                      <xsl:variable name="modDate" select="substring-before(ns1:RegisteredInfo/ns1:ModificationDate, 'T')"/>
                      <xsl:variable name="modTime" select="substring(ns1:RegisteredInfo/ns1:ModificationDate, 12,8)"/>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentModificationUserDate"></span>
                        <xsl:value-of select="$modDate"/> godz.<xsl:value-of select="$modTime"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentModifierUser"></span>
                        <xsl:value-of select="ns1:RegisteredInfo/ns1:Modifier"/>
                      </p>
                    </div>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentZSLCarrier"></p>
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-2" data-phrase-id="sentBasicInfo"></span>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentIdSisc"></span>
                        <xsl:value-of select="ns1:ZSLCarrier/tp:TraderInfo/tp:IdSisc"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderName"></span>
                        <xsl:value-of select="ns1:ZSLCarrier/tp:TraderInfo/tp:TraderName"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityType"></span>
                        <xsl:value-of select="ns1:ZSLCarrier/tp:TraderInfo/tp:TraderIdentityType"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityNumber"></span>
                        <xsl:value-of select="ns1:ZSLCarrier/tp:TraderInfo/tp:TraderIdentityNumber"/>
                      </p>
                    </div>
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-2" data-phrase-id="sentAdress"></span>
                      </p>
                      <xsl:variable name="ulica">
                        <xsl:choose>
                          <xsl:when test="ns1:ZSLCarrier/tp:TraderAddress/tp:FlatNumber != ''">
                            <p>
                              <xsl:value-of select="ns1:ZSLCarrier/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:ZSLCarrier/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:ZSLCarrier/tp:TraderAddress/tp:FlatNumber"/>
                            </p>
                          </xsl:when>
                          <xsl:otherwise>
                            <p>
                              <xsl:value-of select="ns1:ZSLCarrier/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:ZSLCarrier/tp:TraderAddress/tp:HouseNumber"/>
                            </p>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <p>
                        <xsl:value-of select="$ulica"/>
                      </p>
                      <p>
                        <xsl:value-of select="ns1:ZSLCarrier/tp:TraderAddress/tp:PostalCode"/><xsl:text>&#160;</xsl:text> <xsl:value-of select="ns1:ZSLCarrier/tp:TraderAddress/tp:City"/>,<xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:ZSLCarrier/tp:TraderAddress/tp:Country"/>
                      </p>
                    </div>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentRegisteredDevices"></p>
                  <div class="sent-xslt grupInfo">
                    <xsl:choose>
                      <xsl:when test="ns1:RegisteredDevices/tp:DataRow != ''">
                        <table class="sent-xslt table">
                          <tr>
                            <td class="sent-xslt table-header" data-phrase-id="sentGPSDeviceID2" style='width: 11%'></td>
                            <td class="sent-xslt table-header" data-phrase-id="sentGeoLocatorNr" style='width: 11%'></td>
                            <td class="sent-xslt table-header" data-phrase-id="sentGPSDeviceStatus" style='width: 11%'></td>
                            <td class="sent-xslt table-header" data-phrase-id="sentAdditionalInfo" style='width: 13%'></td>
                            <td class="sent-xslt table-header" data-phrase-id="sentCreationDate" style='width: 14%'></td>
                            <td class="sent-xslt table-header" data-phrase-id="sentCreator" style='width: 13%'></td>
                            <td class="sent-xslt table-header" data-phrase-id="sentModificationDate" style='width: 14%'></td>
                            <td class="sent-xslt table-header" data-phrase-id="sentModifier" style='width: 13%'></td>
                          </tr>
                          <xsl:for-each select="ns1:RegisteredDevices/tp:DataRow">
                            <tr>
                              <td class="sent-xslt table-element">
                                <xsl:value-of select="tp:GPSDeviceID"/>
                              </td>
                              <td class="sent-xslt table-element">
                                <xsl:value-of select="tp:GeoLocatorNumber"/>
                              </td>
                              <td class="sent-xslt table-element">
                                <xsl:choose>
                                  <xsl:when test="tp:GPSDeviceStatus = '0'">
                                    <span data-phrase-id="sentZSLServiceStatusValue1"></span>
                                  </xsl:when>
                                  <xsl:when test="tp:GPSDeviceStatus = '2'">
                                    <span data-phrase-id="sentZSLServiceStatusValue2"></span>
                                  </xsl:when>
                                  <xsl:when test="tp:GPSDeviceStatus = '4'">
                                    <span data-phrase-id="sentZSLServiceStatusValue3"></span>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="tp:GPSDeviceStatus"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </td>
                              <td class="sent-xslt table-element">
                                <xsl:value-of select="tp:AdditionalInformation"/>
                              </td>
                              <xsl:variable name="creDate" select="substring-before(tp:CreationDate, 'T')"/>
                              <xsl:variable name="creTime" select="substring(tp:CreationDate, 12,8)"/>
                              <td class="sent-xslt table-element">
                                <xsl:value-of select="$creDate"/> godz.<xsl:value-of select="$creTime"/>
                              </td>
                              <td class="sent-xslt table-element">
                                <xsl:value-of select="tp:Creator"/>
                              </td>
                              <xsl:variable name="modDate" select="substring-before(tp:ModificationDate, 'T')"/>
                              <xsl:variable name="modTime" select="substring(tp:ModificationDate, 12,8)"/>
                              <td class="sent-xslt table-element">
                                <xsl:value-of select="$modDate"/> godz.<xsl:value-of select="$modTime"/>
                              </td>
                              <td class="sent-xslt table-element">
                                <xsl:value-of select="tp:Modifier"/>
                              </td>
                            </tr>
                          </xsl:for-each>
                        </table>
                      </xsl:when>
                      <xsl:otherwise>
                        <div class="sent-xslt info">
                          <p>
                            <span class="sent-xslt element-1" data-phrase-id="sentNoRegisteredDevices"></span>
                          </p>
                        </div>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentAdministratorServicesCarrierZSL"></p>
                  <div class="sent-xslt t1">
                    <div class="sent-xslt grupInfo">
                      <div class="sent-xslt info1">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentPhoneNumber"></span>
                          <xsl:value-of select="ns1:AdministratorServices/tp:AdminPhoneNumber"/>
                        </p>
                      </div>
                      <div class="sent-xslt info1">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentEmail1"></span>
                          <xsl:value-of select="ns1:AdministratorServices/tp:AdminEmail"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </div>
                <xsl:if test="ns1:Comments != ''">
                  <div class="sent-xslt t1">
                    <p class="sent-xslt grupName" data-phrase-id="sentComplianceComments"></p>
                    <div class="sent-xslt t1">
                      <div class="sent-xslt grupInfo">
                        <div class="sent-xslt info">
                          <p>
                            <xsl:value-of select="ns1:Comments"/>
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </xsl:if>
              </section>
            </div>
          </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
